      program sim
c
c---- Compute similarity profiles from mixing layer data.
c
      implicit none
      integer   MAXPTS         ! Max number of points on any profile
      parameter(MAXPTS=101)
      integer   MAXPROF        ! Max number of profiles
      parameter(MAXPROF=15)
c
      real y(MAXPTS,MAXPROF)
      real U(MAXPTS,MAXPROF)
      real uu(MAXPTS,MAXPROF)
      real vv(MAXPTS,MAXPROF)
      real uv(MAXPTS,MAXPROF)
      real Ustar(MAXPTS,MAXPROF)
      real  Ufit(MAXPTS,MAXPROF)
      real  Uerr(MAXPTS,MAXPROF)
      real   eta(MAXPTS,MAXPROF)
      real ymy05b(MAXPTS,MAXPROF)
      real simUstar(MAXPTS)
      real    simuv(MAXPTS)
      real    simuu(MAXPTS)
      real    simvv(MAXPTS)
      real        b(MAXPROF)
      real      y10(MAXPROF)
      real      y90(MAXPROF)
      real      y05(MAXPROF)
      real       U1(MAXPROF)
      real       U2(MAXPROF)
      real     xloc(MAXPROF)
      integer ixloc(MAXPROF)   ! x-location of given profile
      integer  npts(MAXPROF)   ! Max number of points on given profile
      integer  ista(3)
      real     xsta(3)
      character*(50) fname
c
      real    U05,dU
      real    U10,U90
      real    ymy05btmp,tmp
      real    c0,c1,R
      real    v1,v2,v3,v4,v5
      integer ipts,iprof,nprof
      integer i
      integer i10,i90
      integer j,jmax
      character*(1000) text
c
      integer  lenstr
      external lenstr
      real     erf
      external erf
c
c==== Read raw profile data into memory.
      ipts=0
      iprof=0
    1 format(a)
      write(*,1) 'Enter filename of profile data:'
      read (*,1) fname
      open(unit=10,file=trim(fname),status='OLD',form='FORMATTED')
   10 continue
        read(10,1,END=100) text
        if (text.eq.' ' .or. text(2:len(text)).eq.' ') then
c         Skip blank lines.
c
        elseif (text(1:1).eq.'#') then
c         Skip comment lines.
c
        elseif (text(1:9).eq.'Variables') then
c         Skip Tecplot "Variables" header info.
c
        elseif (text(1:4).eq.'Zone' .or.
     &          text(1:3).eq.'x ='       ) then
c         Extract Tecplot "Zone" header info.
          if (iprof.gt.0)
     &      npts(iprof)=ipts   ! Set max number of points on last profile
          ipts=0
          iprof=iprof+1
          i=index(text,'x =')
          if (i.gt.0) then
            read(text(i+3:len(text)),*) ixloc(iprof)
          else
            ixloc(iprof)=0
          endif
c
        else
c         Numeric data:  y,U,u,v,uv/(u*v).
          read(text,*,ERR=10) v1,v2,v3,v4,v5
          if (iprof.eq.0) then
c           If no prior zone header info read, force zone 1.
            iprof=1
            ixloc(iprof)=0
          endif
          ipts=ipts+1
          y(ipts,iprof)=v1
          U(ipts,iprof)=v2
          uu(ipts,iprof)= v3**2
          vv(ipts,iprof)= v4**2
          uv(ipts,iprof)=-v5*(v3*v4)
        endif
      goto 10
c
  100 continue
      close(unit=10)
c==== All profiles now read into memory.
      npts(iprof)=ipts   ! Set max number of points on last profile
      nprof=iprof
      write(*,*) 'Number of profiles read = ',nprof
c
c
c==== Obtain edge velocities from user.
c
      write(*,1)
      write(*,1) 'Variables="y(mm)","U(m/s)"'
      do iprof=1,nprof
        xloc(iprof)=ixloc(iprof)
        write(*,111) ixloc(iprof)
        write(*,112)
  111   format('Zone T="x=',i3,' mm", F="POINT"')
  112   format('#   y(mm)    U(m/s)')
        do ipts=1,npts(iprof)
          write(*,113) y(ipts,iprof),U(ipts,iprof)
  113     format(2f12.6)
        enddo
        write(*,*) 'Enter U1,U2:'
        read(*,*) U1(iprof),U2(iprof)
c
c----   Ignore user input.  Instead use max/min values.
        U1(iprof)=-1.0E+5
        U2(iprof)= 1.0E+5
        do ipts=1,npts(iprof)
          U1(iprof)=max(U1(iprof),U(ipts,iprof))
          U2(iprof)=min(U2(iprof),U(ipts,iprof))
        enddo
      enddo
c
c
c==== Find out which 3-locations to use for averaging similarity profile.
      write(*,1) 
      write(*,1) 'Profile Summary:'
      do iprof=1,nprof
        write(*,151) xloc(iprof)
  151   format('  x = ',f5.1)
      enddo
      write(*,1) 'Enter x-locations of 3 profiles to use for averaging:'
      read(*,*) (xsta(i), i=1,3)
      do i=1,3
        do iprof=1,nprof
          if (abs(xsta(i)-xloc(iprof)).lt.0.5) ista(i)=iprof
        enddo
      enddo
      write(*,*) 'Requested x-stations at: ',(xsta(i),i=1,3)
      write(*,*) 'Using     x-stations at: ',(xloc(ista(i)),i=1,3)
c
c==== Determine center location (y05) for each profile.
c
      do iprof=1,nprof
        U05=0.5*(U1(iprof)+U2(iprof))
        do ipts=1,npts(iprof)-1
          if (U(ipts  ,iprof).le.U05 .and.
     &        U(ipts+1,iprof).ge.U05) then
            y05(iprof) = y(ipts,iprof) + (y(ipts+1,iprof)-y(ipts,iprof))
     &           * (U05-U(ipts,iprof)) / (U(ipts+1,iprof)-U(ipts,iprof))
          endif
        enddo
      enddo
c
c
c==== Determine 10% dU Thickness.
c----   Ustar = 0.5*(1+erf(eta))
c----   eta   = sigma*(y-y05)/(x-x0)
      write(*,*)
      write(*,*) 'xloc   y10   y90   y05   b   U10   U90'
      do i=1,3
        iprof = ista(i)
        i10 = 0
        i90 = 0
        U10 = U2(iprof) + 0.10*(U1(iprof)-U2(iprof))
        U90 = U2(iprof) + 0.90*(U1(iprof)-U2(iprof))
        do ipts=1,npts(iprof)
          Ustar(ipts,iprof) = (U(ipts,iprof)-U2(iprof))
     &                      /     (U1(iprof)-U2(iprof))
          if (ipts.lt.npts(iprof)) then
            if (U(ipts  ,iprof).gt.U10 .and.
     &          U(ipts+1,iprof).le.U10      ) i10=ipts
            if (U(ipts  ,iprof).gt.U90 .and.
     &          U(ipts+1,iprof).le.U90      ) i90=ipts
          endif
        enddo
        y10(iprof) =y(i10,iprof)  + (y(i10+1,iprof)-y(i10,iprof))
     &     * (U10 - U(i10,iprof)) / (U(i10+1,iprof)-U(i10,iprof))
        y90(iprof) =y(i90,iprof)  + (y(i90+1,iprof)-y(i90,iprof))
     &     * (U90 - U(i90,iprof)) / (U(i90+1,iprof)-U(i90,iprof))
        y05(iprof) = (y90(iprof) + y10(iprof)) * 0.5
        b(iprof)   =  y90(iprof) - y10(iprof)
        write(*,*) ixloc(iprof),
     &             y10(iprof),y90(iprof),y05(iprof),b(iprof),U10,U90
        do ipts=1,npts(iprof)
c----     Goebel's similarity variable:  (y-y05)/b
          ymy05b(ipts,iprof) = (y(ipts,iprof)-y05(iprof)) / b(iprof)
        enddo
      enddo
c
      if (.false.) then
      do iprof=nprof,nprof
        write(*,*)
        write(*,1) '   y   y05   (y-y05)/b   Ustar   uv   uu  vv'
        do ipts=1,npts(iprof)
          dU = U1(iprof)-U2(iprof)
          write(*,*) y(ipts,iprof),y05(iprof),
     &               ymy05b(ipts,iprof),
     &               Ustar(ipts,iprof),
     &               uv(ipts,iprof) / dU**2,
     &               uu(ipts,iprof) / dU**2,
     &               vv(ipts,iprof) / dU**2
       enddo
      enddo
      endif
c
      if (.true. ) then
c----   Write the 3 profiles to average side-by-side.
        write(*,*) 
        write(*,102,ADVANCE='NO') (ixloc(ista(i)),i=1,3)
        write(*,*)
  102   format('    x = ',i3,' mm     ')
        write(*,*) '(y-y0)/b   Ustar   '
     &    //       '(y-y0)/b   Ustar   '
     &    //       '(y-y0)/b   Ustar   '
        do ipts=1,max(npts(ista(1)),npts(ista(2)),npts(ista(3)))
          if (ipts.le.npts(ista(1))) then
            write(*,103,ADVANCE='NO')
     &        ymy05b(ipts,ista(1)),Ustar(ipts,ista(1)) 
          else
            write(*,103,ADVANCE='NO') 0.0, 0.0
          endif
          if (ipts.le.npts(ista(2))) then
            write(*,103,ADVANCE='NO')
     &        ymy05b(ipts,ista(2)),Ustar(ipts,ista(2)) 
          else
            write(*,103,ADVANCE='NO') 0.0, 0.0
          endif
          if (ipts.le.npts(ista(3))) then
            write(*,103,ADVANCE='NO')
     &        ymy05b(ipts,ista(3)),Ustar(ipts,ista(3)) 
          else
            write(*,103,ADVANCE='NO') 0.0, 0.0
          endif
          write(*,*)
  103     format(f8.4,f10.6)
        enddo
      endif
c
      if (.true. ) then
c----   Write the 3 profiles to average one after another.
        do i=1,3
          iprof=ista(i)
          write(*,*)
          do ipts=1,npts(iprof)
            write(*,103) ymy05b(ipts,iprof),Ustar(ipts,iprof)
          enddo
        enddo
      endif
c
      write(*,*)
c
c==== Average 3 profiles to obtain similarity profile.
!     write(*,*)
!     write(*,1) '0    1    (y-y0)/b   Ustar   uv   uu  vv  '
      jmax=31
      do j=1,jmax
        simUstar(j) = 0.0
        simuv(j) = 0.0
        simuu(j) = 0.0
        simvv(j) = 0.0
      enddo
      do i=1,3
        iprof = ista(i)
        dU = U1(iprof)-U2(iprof)
!       dU = 616.-100.
        do j=1,jmax
          ymy05btmp = -1.5 + 3.0*(j-1.)/(jmax-1.)
          if     (ymy05b(npts(iprof),iprof).gt.ymy05btmp) then
c----       Requested location lies within the lo-speed core stream.
            simUstar(j) = simUstar(j) + 0.0
            simuu(j)    = simuu(j)    + 0.0
            simvv(j)    = simvv(j)    + 0.0
            simuv(j)    = simuv(j)    + 0.0
          elseif (ymy05b(1,iprof).lt.ymy05btmp) then
c----       Requested location lies within the hi-speed core stream.
            simUstar(j) = simUstar(j) + 1.0
            simuu(j)    = simuu(j)    + 0.0
            simvv(j)    = simvv(j)    + 0.0
            simuv(j)    = simuv(j)    + 0.0
          else
c----       Requested location lies within available data.  Interpolate.
            do ipts=1,npts(iprof)-1
c-out         if (ymy05b(ipts  ,iprof).lt.ymy05btmp .and.
c-out&            ymy05b(ipts+1,iprof).ge.ymy05btmp      ) then
              if (ymy05b(ipts  ,iprof).gt.ymy05btmp .and.
     &            ymy05b(ipts+1,iprof).le.ymy05btmp      ) then
                tmp = (ymy05btmp            - ymy05b(ipts,iprof))
     &              / (ymy05b(ipts+1,iprof) - ymy05b(ipts,iprof))
                simUstar(j) = simUstar(j) + Ustar(ipts,iprof) + tmp *
     &                       (Ustar(ipts+1,iprof) - Ustar(ipts,iprof))
                simuv(j) = simuv(j) + (uv(ipts,iprof) + tmp *
     &                    (uv(ipts+1,iprof) - uv(ipts,iprof)))
     &                   / dU**2
                simuu(j) = simuu(j) + (uu(ipts,iprof) + tmp *
     &                    (uu(ipts+1,iprof) - uu(ipts,iprof)))
     &                   / dU**2
                simvv(j) = simvv(j) + (vv(ipts,iprof) + tmp *
     &                    (vv(ipts+1,iprof) - vv(ipts,iprof)))
     &                   / dU**2
!               write(*,*) 0.0,1.0,ymy05btmp,
!    &                     simUstar(j),simuv(j),simuu(j),simvv(j)
              endif
            enddo
          endif
        enddo
      enddo
      do j=1,jmax
        simUstar(j) = simUstar(j) / 3
        simuv(j) = simuv(j) / 3
        simuu(j) = simuu(j) / 3
        simvv(j) = simvv(j) / 3
      enddo
c
c==== Write similarity profile.
c---- Convert (y-y0)/b to eta=sigma*(y-y05)/(x-x0) using erf profile.
      write(*,1)
      write(*,1) '==========================='
      write(*,1) 'Similarity profiles follow:'
      write(*,1) '==========================='
      write(*,1) 'Variables="(y-y0)/b","eta=sigma*(y-y05)/(x-x0)"'
     & //            ',"Ustar","-uv/dU**2","uu/dU**2","vv/dU**2"'
     & //            ',"u/dU","v/dU"'
      write(*,1) 'Zone T="Goebel Similarity Profiles", F="POINT"'
      write(*,1) '# (y-y0)/b ..eta.. .Ustar.'
     & //        ' .-uv/dU^2 .uu/dU^2. .vv/dU^2. ..u/dU. ..v/dU.'
      do j=1,jmax
        ymy05btmp = -1.5 + 3.0*(j-1.)/(jmax-1.)
        write(*,301) ymy05btmp,
     &               ymy05btmp*1.812, 
     &               simUstar(j),simuv(j),simuu(j),simvv(j),
     &               sqrt(simuu(j)),sqrt(simvv(j))
  301   format(f10.4,f8.4,f8.4,3f10.6,2f8.4)
      enddo
c
      end
c=======================================================================
      function lenstr(text)
c
c---- Determine non-blank length of text.
c
      character*(*) text
      lenstr=0
      maxl=len(text)
      do l=maxl,1,-1
        if (text(l:l).ne.' ') then
          lenstr=l
          GOTO 999
        endif
      enddo
  999 return
      end
c=======================================================================
      function erf(x)
c
c                   E R R O R   F U N C T I O N
c
      if(x.eq.0.) then
        erf=0.
      else
        x2=x*x
        t=1./(1.+.3275911*abs(x))
        erf=1.-t*(.25482959+t*(-.28449674+t*(1.4214137
     *        +t*(-1.453152+t*1.0614054))))*exp(-x2)
        if(x.lt.0.) erf=-erf
      endif
      return
      end
c=======================================================================
