      program expgrowth
c
c---- Dutton-Goebel Mixing Layer.
c---- This program will process the raw experimental data.
c----  -Compute the shear layer thickness from the velocity profiles.
c----  -Put the profile data into a form more suitable for plotting.
c----    Old Variables         New Variables
c----      y(mm)                 y(mm)
c----      U(m/s)                U(m/s)
c----      sqrt(uu)(m/s)         sqrt(uu)(m/s)
c----      sqrt(vv)(m/s)         sqrt(vv)(m/s)
c----      <uv>/sqrt(uu*vv)      <uv>/sqrt(uu*vv)
c----                            uu(m2/s2)
c----                            vv(m2/s2)
c----                            uv(m2/s2)
c----                            y-y0(mm)
c----                            U(m/s)        shifted
c----                            sqrt(uu)(m/s) shifted
c----                            sqrt(vv)(m/s) shifted
c----                            uv(m2/s2)     shifted
c
      implicit none
      integer   JDIM
      parameter(JDIM=500)
      real                 y(JDIM)  ! position         y  (mm)
      real              Ubar(JDIM)  ! mean velocity    U  (m/s)
      real                 u(JDIM)  ! u-intensity      u' (m/s)
      real                 v(JDIM)  ! v-intensity      v' (m/s)
      real                uv(JDIM)  ! shear stress   u'v' (m2/s2)
      real            uvnorm(JDIM)  ! shear stress  <u'v'>/u'*v'
      integer         izone,jmax,ixloc
      character*(240) text,zonename,oldvarnames,newvarnames
      character*(80)  ior1fname,iow0fname,iow1fname,iow2fname
c
      integer    ior1,iow0,iow1,iow2
      common /io/ior1,iow0,iow1,iow2
      real        x,U1,U2,U10,U90,y10,y90,y0,b,vort
      common /thk/x,U1,U2,U10,U90,y10,y90,y0,b,vort
      real          Ubarshift,ushift,vshift,uvshift
      common /shift/Ubarshift,ushift,vshift,uvshift
      integer  lenstr
      external lenstr
      logical  isnumber
      external isnumber
c
      oldvarnames =  ' '
      newvarnames =  '"uu(m2/s2)"'
     &           // ',"vv(m2/s2)"'
     &           // ',"-uv(m2/s2)"'
     &           // ',"y-y0(mm)"'
     &           // ',"U(m/s) shifted"'
     &           // ',"sqrt(uu)(m/s) shifted"'
     &           // ',"sqrt(vv)(m/s) shifted"'
     &           // ',"-uv(m2/s2) shifted"'
c
    1 format(a)
      ior1=11
      write(*,*) 'Enter input file containing velocity profiles.'
      read (*,1) ior1fname
      open(unit=ior1,file=ior1fname,form='FORMATTED',status='OLD')
c
      iow1=21
      write(*,*) 'Enter output file for growth rate info.'
      read (*,1) iow1fname
      open(unit=iow1,file=iow1fname,form='FORMATTED',status='UNKNOWN')
c
      iow2=22
      write(*,*) 'Enter output file for profile info.'
      read (*,1) iow2fname
      open(unit=iow2,file=iow2fname,form='FORMATTED',status='UNKNOWN')
c
      iow0=20
      write(*,*) 'Enter output file for log info.'
      read (*,1) iow0fname
      open(unit=iow0,file=iow0fname,form='FORMATTED',status='UNKNOWN')
c
      write(*,*) 'Value to shift  U(m/s)  profiles?  (Recommend  300)'
      read (*,*) Ubarshift
      write(*,*) 'Value to shift  u(m/s)  profiles?  (Recommend   50)'
      read (*,*) ushift
      write(*,*) 'Value to shift  v(m/s)  profiles?  (Recommend   25)'
      read (*,*) vshift
      write(*,*) 'Value to shift uv(m/s)2 profiles?  (Recommend 2500)'
      read (*,*) uvshift
c
      write(iow0,1) ior1fname(1:lenstr(ior1fname))
      write(iow0,1) iow1fname(1:lenstr(iow1fname))
      write(iow0,1) iow2fname(1:lenstr(iow2fname))
      write(iow0,1) iow0fname(1:lenstr(iow0fname))
      write(iow0,*) Ubarshift
      write(iow0,*)    ushift
      write(iow0,*)    vshift
      write(iow0,*)   uvshift
c
      izone=0
      jmax=0
  100 continue
        read(ior1,1,END=200) text
        if     (text      .eq. ' ' .or.
     &          text      .eq. '	') then
c----     Blank lines.
          write(iow2,*)   
c
        elseif (text(1:1) .eq. '#') then
c----     Comment lines.
          if (index(text,'y(mm)').eq.0) then
c----       Ignore header lines containing 'y(mm)'.
            write(iow2,1) text(1:lenstr(text))
          endif
c
        elseif (text(1:3) .eq. 'Var') then
c----     If variable names given, append with new variables.
          oldvarnames = text(1:lenstr(text))
          write(iow2,1) oldvarnames(1:lenstr(oldvarnames)) 
     &        // ',' // newvarnames(1:lenstr(newvarnames))
c
        elseif (text(1:4) .eq. 'Zone' .or.
     &          text(1:3) .eq. 'x =') then
c----     Write variable names if not already done.
          if (oldvarnames .eq. ' ') then
            oldvarnames = 'Variables'
     &                 // '="y(mm)"'
     &                 // ',"U(m/s)"'
     &                 // ',"sqrt(uu)(m/s)"'
     &                 // ',"sqrt(vv)(m/s)"'
     &                 // ',"<uv>/sqrt(uu*vv)"'
            write(iow2,1) oldvarnames(1:lenstr(oldvarnames)) 
     &          // ',' // newvarnames(1:lenstr(newvarnames))
          endif
c----     Found a zone header.
          if (jmax.gt.0) then
c----       Process the previous profile.
            call thkness(zonename,jmax,y,Ubar)
            call profile(zonename,izone,jmax,y,Ubar,u,v,uvnorm,uv)
          endif
c----     Save ZoneName and reset number of points.
          if (text(1:4).eq.'Zone') then
            zonename = text(1:lenstr(text))
          else
            read(text(4:lenstr(text)),*) ixloc
            write(zonename,49) ixloc
   49       format('Zone T="Goebel, x=',i4,' mm", F="POINT"')
          endif
          izone = izone + 1
          jmax = 0
c
        elseif (isnumber(text) .eq. .false.) then
c----     Uncommented text.
c----     Ignore header lines containing 'y(mm)'.
          if (index(text,'y(mm)').eq.0) then
            write(iow2,1) '# ' // text(1:lenstr(text))
          endif
        else
c----     Read the data.
          jmax=jmax+1
          read(text,*,END=200) y(jmax),Ubar(jmax),u(jmax),v(jmax),
     &                         uvnorm(jmax)
          uv(jmax) = uvnorm(jmax) * u(jmax)*v(jmax)
        endif
      goto 100
c
  200 continue
c---- EOF reached.
      if (jmax.gt.0) then
c----   Process the previous profile.
        call thkness(zonename,jmax,y,Ubar)
        call profile(zonename,izone,jmax,y,Ubar,u,v,uvnorm,uv)
      endif
c
      close(unit=ior1)
      close(unit=iow1)
      close(unit=iow2)
      close(unit=iow0)
      end
c=======================================================================
      function lenstr(text)
c
c---- Determine non-blank length of text.
c
      implicit none
      integer lenstr,l,maxl
      character*(*) text
      lenstr=0
      maxl=len(text)
      do l=maxl,1,-1
        if (text(l:l).ne.' ') then
          lenstr=l
          GOTO 999
        endif
      enddo
  999 return
      end
c=======================================================================
      function isnumber(text)
c
c---- Determine whether text begins with a number (int,real,double).
c
      implicit none
      logical isnumber
      character*(*)    text
      double precision DP
      isnumber = .false.
      read(text,*,ERR=999) DP
      isnumber = .true.
  999 return
      end
c=======================================================================
      subroutine thkness(zonename,jmax,y,U)
c
c---- Compute the shear layer thickness.
c---- Computed from 10%*dU to 90%*dU locations.
c
      implicit none
      real          y(*),U(*)
      integer       jmax
      character*(*) zonename
c
      real    DU
      real    dudy
      real    U30,U70,c0,c1,R
      real    tmpy(200),tmpU(200)
      integer jj
      integer j,j10,j90
      integer iheader
      save    iheader
      data    iheader/0/
c
      integer    ior1,iow0,iow1,iow2
      common /io/ior1,iow0,iow1,iow2
      real        x,U1,U2,U10,U90,y10,y90,y0,b,vort
      common /thk/x,U1,U2,U10,U90,y10,y90,y0,b,vort
      integer  lenstr
      external lenstr
c
      write(*,*)
      write(*,*) zonename(1:lenstr(zonename))
      write(*,*) '     y(mm)      U(m/s)'
      do j=1,jmax
        write(*,*) y(j),U(j)
      enddo
c
c---- Determine the freestream values U1,U2.
      write(*,*) 'Enter U1(m/s) and U2(m/s) for this profile:'
      read(*,*) U1,U2
      write(iow0,*) U1,U2
c
      DU = U1 - U2
      U10 = U2 + 0.10*DU
      U90 = U1 - 0.10*DU
!     write(*,*) 'U1,U2,DU,U10,U90 = ',U1,U2,DU,U10,U90
c
c---- March from the top wall down, searching for the 10% DU locations.
c---- Note:  j=1 is towards top wall (y>0).
      j10 = 0
      j90 = 0
      do j=1,jmax
        if (U(j).ge.U90 .and. j.gt.j90) j90=j
        if (U(j).ge.U10 .and. j.gt.j10) j10=j
!       write(*,62) j,j90,j10,U(j),U10,U90
! 62    format(3i5,3f10.3)
      enddo
c
c---- Output Results.
      if (iheader.eq.0) then
        write(iow1,911) 
        iheader = 1
      endif
      j =  index(zonename,'x= ')
      read(zonename(j+2:len(zonename)),*) x
c
c     Use closest data point with U > U10 or U90.
      y10 = y(j10)
      y90 = y(j90)
      if (.true. ) then
c       Interpolate between data points, instead.
        if (j90.lt.jmax) then
          y90 = y(j90+1) + (y(j90)-y(j90+1)) * (U90   -U(j90+1))
     &                                       / (U(j90)-U(j90+1))
        endif
        if (j10.lt.jmax) then
          y10 = y(j10+1) + (y(j10)-y(j10+1)) * (U10   -U(j10+1))
     &                                      / (U(j10)-U(j10+1))
        endif
      endif
      y0 = (y90+y10)*0.5
      b  =  y90-y10
c
c---- Compute Vorticity Thickness.
c     Method 1:  Local slope.
      dudy = 0.
      do j=j10,j90,(j90-j10)/abs(j90-j10)
        if (j.gt.1 .and. j.lt.jmax) then
          dudy = max( dudy, (U(j+1)-U(j-1)) / (y(j+1)-y(j-1)) )
        endif
      enddo
      vort = DU/dudy
c     Method2:  Linear-fit slope between 30-70% delta U region.
      U30 = U2 + 0.20*(U1-U2)
      U70 = U2 + 0.80*(U1-U2)
      jj=0
      do j=1,jmax
        if (U(j).ge.U30 .and. U(j).le.U70) then
          jj=jj+1
          tmpy(jj)=y(j)
          tmpU(jj)=U(j)
        endif
      enddo
      call LSfit(jj,tmpy,tmpU,c0,c1,R)
      if (c1 .gt. 1.0E-3) then
        vort=(U1-U2)/c1
      else
        vort=0.
      endif
c
c---- Write mixing layer thickness info to output file.
      write(iow1,912)            int(x),y10,y90,y0,b,vort,U10,U90,U2,U1
c
c
  911 format('# Dutton-Goebel Mixing Layer Data.'
     &  ,/,  'Variables="x(mm)","y10(mm)","y90(mm)","y0(mm)","b(mm)",'
     &      ,'"VortThk(mm)","U10(m/s)","U90(m/s)","U2(m/s)","U1(m/s)"'
     &  ,/,  'Zone T="Goebel", F="POINT"'
     &  ,/,     '#','x(mm)',' y10(mm)',' y90(mm)',
     &                      '  y0(mm)','   b(mm)',' VortThk(mm)',
     &                      '  U10(m/s)','  U90(m/s)',
     &                      '   U2(m/s)','   U1(m/s)')
  912 format(    2X,I4,4F8.3,F12.3,4F10.3)
  999 return
      end
c=======================================================================
      subroutine profile(zonename,izone,jmax,y,Ubar,u,v,uvnorm,uv)
c
c---- Write new profile data.
c
      implicit none
      character*(*) zonename
      integer              iow2
      integer              izone
      integer              jmax
      real               y(jmax)  ! position         y  (mm)
      real            Ubar(jmax)  ! mean velocity    U  (m/s)
      real               u(jmax)  ! u-intensity      u' (m/s)
      real               v(jmax)  ! v-intensity      v' (m/s)
      real              uv(jmax)  ! shear stress   u'v' (m2/s2)
      real          uvnorm(jmax)  ! shear stress  <u'v'>/u'*v'
c
      integer    ior1,iow0,iow1,iow2
      common /io/ior1,iow0,iow1,iow2
      real        x,U1,U2,U10,U90,y10,y90,y0,b,vort
      common /thk/x,U1,U2,U10,U90,y10,y90,y0,b,vort
      real          Ubarshift,ushift,vshift,uvshift
      common /shift/Ubarshift,ushift,vshift,uvshift
      integer  lenstr
      external lenstr
c
      integer  j,izoneoffset
      real     Ubaroffset,uoffset,voffset,uvoffset
c
c
      izoneoffset = 1
      if (izone.gt.5) izoneoffset = 6
      Ubaroffset = (izone-izoneoffset) * Ubarshift
         uoffset = (izone-izoneoffset) *    ushift
         voffset = (izone-izoneoffset) *    vshift
        uvoffset = (izone-izoneoffset) *   uvshift
c
    1 format(a)
      write(iow2,1) zonename(1:lenstr(zonename))
      write(iow2,921) 
      write(iow2,922)            int(x),y10,y90,y0,b,vort,U10,U90,U2,U1
  921 format('#',1X,'X(mm)',' y10(mm)',' y90(mm)',
     &                      '  y0(mm)','   b(mm)',' VortThk(mm)',
     &                      '  U10(m/s)','  U90(m/s)',
     &                      '   U2(m/s)','   U1(m/s)')
  922 format('#',2X,I4,4F8.3,F12.3,4F10.3)
      write(iow2,1) '#                                  '
     &           // '                                   '
     &           // '         <------------ Shifted ------------>'
      write(iow2,1) '#y(mm) U(m/s)  u(m/s)  v(m/s) <uv>/u*v '
     &           // 'uu(m2/s2) vv(m2/s2) -uv(m2/s2) y-y0(mm) '
     &           // 'U(m/s)   u(m/s)   v(m/s) -uv(m2/s2)'
      do j=1,jmax
        write(iow2,923) y(j),Ubar(j),u(j),v(j),uvnorm(j),
     &                  u(j)**2,
     &                  v(j)**2,
     &                -uv(j),
     &                  y(j)-y0,
     &               Ubar(j)+Ubaroffset,
     &                  u(j)+uoffset,
     &                  v(j)+voffset,
     &                -uv(j)+uvoffset
  923   format(x,F5.1,F7.1,2F08.3,F9.4,
     &                     2F10.3,F11.3,F9.3,
     &                F7.1,2F09.3,F11.3)
      enddo
c
      return
      end
c=======================================================================
      subroutine LSfit(npts,x,y, a0,a1,r)
c
c---- Compute linear least-squares fit of data (x,y).
c----   y = a0 + a1*x    R = correlation coefficient
c
      implicit none
      integer npts
      real  x(npts),y(npts)
      real a0,a1,r
c
      double precision  sumx,sumy,sumxx,sumxy,xave,yave,da0,da1
      double precision  st,sr,syx,r2,dr
      integer n
c
      sumx  = 0.
      sumy  = 0.
      sumxx = 0.
      sumxy = 0.
      do n=1,npts
        sumx  = sumx  + dble(x(n))
        sumy  = sumy  + dble(y(n))
        sumxx = sumxx + dble(x(n))*dble(x(n))
        sumxy = sumxy + dble(x(n))*dble(y(n))
      enddo
      xave = sumx / npts
      yave = sumy / npts
      da1 = (npts*sumxy-sumx*sumy) / (npts*sumxx-sumx**2)
      da0 = yave - da1*xave
c
      st = 0.
      sr = 0.
      do n=1,npts
        st = st + (y(n) - yave)**2
        sr = sr + (y(n) - da1*x(n) - da0)**2
      enddo
      syx = sqrt(sr/(npts-2))
      r2  = (st-sr)/st
      dr  = sqrt(r2)
      a0 = da0
      a1 = da1
      r  = dr
c
      return
      end
c=======================================================================
