! u velocity component
      FUNCTION UMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X   -> Horizontal coordinate
!  Y   -> Vertical coordinate
!  UMS -> Horizontal velocity component, u
!
      REAL*8 UMS,X,Y,ETA,U1,DERF
!
      U1=1.D0
      ETA=SIGMA*Y/X
!
      UMS=DERF(ETA)
!
      RETURN
      END FUNCTION UMS
!
      FUNCTION DUDXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DUDXMS -> Derivative of u with respect to x
!
      REAL*8 DUDXMS,X,Y,ETA,U1
!
      U1=1.D0
      ETA=SIGMA*Y/X
!
      DUDXMS=-U1*SIGMA*Y*2.D0/(X*X*SQRT(PI))*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION DUDXMS
!
      FUNCTION DUDYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DUDYMS -> Derivative of u with respect to y
!
      REAL*8 DUDYMS,X,Y,ETA,U1
!
      U1=1.D0
      ETA=SIGMA*Y/X
!
      DUDYMS=U1*SIGMA*2.D0/(X*SQRT(PI))*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION DUDYMS
!
      FUNCTION DUDX2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DU2DX2MS -> Second derivative of u with respect to x
!
      REAL*8 DUDX2MS,X,Y,ETA,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=4.D0*U1/SQRT(PI)
      X2=X*X
!
      DUDX2MS=T1*(ETA/X2)*EXP(-ETA*ETA)*(1.D0-ETA*ETA)
!
      RETURN
      END FUNCTION DUDX2MS
!
      FUNCTION DUDY2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DU2DY2MS -> Second derivative of u with respect to y
!
      REAL*8 DUDY2MS,X,Y,ETA,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=4.D0*U1/SQRT(PI)
      X2=SIGMA/X
!
      DUDY2MS=-T1*X2*X2*ETA*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION DUDY2MS
!
      FUNCTION DUDXYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DUDXYMS  -> Second derivative of u with respect to x and y
!
      REAL*8 DUDXYMS,X,Y,ETA,U1,T1
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=2.D0*U1/SQRT(PI)*SIGMA/X/X
!
      DUDXYMS=T1*EXP(-ETA*ETA)*(2.D0*ETA*ETA-1.D0)
!
      RETURN
      END FUNCTION DUDXYMS
!
      FUNCTION DUDX2YMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X         -> Horizontal coordinate
!  Y         -> Vertical coordinate
!  DUDX2YMS  -> Third derivative of u with respect to x and y
!
      REAL*8 DUDX2YMS,X,Y,ETA,ETA2,U1,T1
!
      U1=1.D0
      ETA=SIGMA*Y/X
      ETA2=ETA*ETA
      T1=4.D0*U1/SQRT(PI)*SIGMA/X/X/X
!
      DUDX2YMS=T1*EXP(-ETA2)*(1.D0+2.D0*ETA2*(ETA2-2.5D0))
!
      RETURN
      END FUNCTION DUDX2YMS
!
      FUNCTION DUDY3MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DUDY3MS  -> Third derivative of u with respect to y
!
      REAL*8 DUDY3MS,X,Y,ETA,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      X2=SIGMA/X
      T1=4.D0*U1/SQRT(PI)*X2*X2*X2
!
      DUDY3MS=T1*EXP(-ETA*ETA)*(2.D0*ETA*ETA-1.D0)
!
      RETURN
      END FUNCTION DUDY3MS
!
! v velocity component
!
      FUNCTION VMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X   -> Horizontal coordinate
!  Y   -> Vertical coordinate
!  VMS -> Vertical velocity component, v
!
      REAL*8 VMS,X,Y,ETA,U1,T1
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=U1/(SIGMA*SQRT(PI))
!
      VMS=T1*(1.D0-EXP(-ETA*ETA))
!
      RETURN
      END FUNCTION VMS
!
      FUNCTION DVDXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DVDXMS -> Derivative of v with respect to x
!
      REAL*8 DVDXMS,X,Y,ETA,U1
!
      U1=1.D0
      ETA=SIGMA*Y/X
!
      DVDXMS=-U1*SIGMA*Y*Y*2.D0/(X*X*X*SQRT(PI))*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION DVDXMS
!
      FUNCTION DVDYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DVDYMS -> Derivative of v with respect to y
!
      REAL*8 DVDYMS,X,Y,ETA,U1
!
      U1=1.D0
      ETA=SIGMA*Y/X
!
      DVDYMS=U1*SIGMA*Y*2.D0/(X*X*SQRT(PI))*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION DVDYMS
!
      FUNCTION DVDX2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  DVDX2MS -> Second derivative of v with respect to x
!
      REAL*8 DVDX2MS,X,Y,ETA,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=2.D0*U1/SQRT(PI)
      X2=SIGMA*Y*Y/(X*X*X*X)
!
      DVDX2MS=T1*X2*EXP(-ETA*ETA)*(3.D0-2.D0*ETA*ETA)
!
      RETURN
      END FUNCTION DVDX2MS
!
      FUNCTION DVDY2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  DVDY2MS -> Second derivative of v with respect to y
!
      REAL*8 DVDY2MS,X,Y,ETA,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=2.D0*U1/SQRT(PI)
      X2=SIGMA/(X*X)
!
      DVDY2MS=T1*X2*EXP(-ETA*ETA)*(1.D0-2.D0*ETA*ETA)
!
      RETURN
      END FUNCTION DVDY2MS
!
      FUNCTION DVDXYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  DVDXYMS -> Second derivative of v with respect to x and y
!
      REAL*8 DVDXYMS,X,Y,ETA,U1,T1
!
      U1=1.D0
      ETA=SIGMA*Y/X
      T1=4.D0*U1/SQRT(PI)*SIGMA*Y/X/X/X
!
      DVDXYMS=T1*EXP(-ETA*ETA)*(ETA*ETA-1.D0)
!
      RETURN
      END FUNCTION DVDXYMS
!
      FUNCTION DVDXY2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DVDXY2MS -> Third derivative of v with respect to x and y
!
      REAL*8 DVDXY2MS,X,Y,ETA,ETA2,U1,T1
!
      U1=1.D0
      ETA=SIGMA*Y/X
      ETA2=ETA*ETA
      T1=4.D0*U1/SQRT(PI)*SIGMA/X/X/X
!
      DVDXY2MS=T1*EXP(-ETA2)*(2.D0*ETA2*(2.5D0-ETA2)-1.D0)
!
      RETURN
      END FUNCTION DVDXY2MS
!
      FUNCTION DVDX3MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DVDXY3MS -> Third derivative of v with respect to x
!
      REAL*8 DVDX3MS,X,Y,ETA,ETA2,U1,T1,X2
!
      U1=1.D0
      ETA=SIGMA*Y/X
      ETA2=ETA*ETA
      T1=4.D0*U1/SQRT(PI)
      X2=ETA*Y/(X*X*X*X)
!
      DVDX3MS=T1*X2*EXP(-ETA2)*(2.D0*ETA2*(4.5D0-ETA2)-6.D0)
!
      RETURN
      END FUNCTION DVDX3MS
!
!  Pressure Coefficient
!
      FUNCTION PMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X   -> Horizontal coordinate
!  Y   -> Vertical coordinate
!  PMS -> Pressure 
!
      REAL*8 PMS,X,Y
!
      PMS=0.5d0*log(2.d0*x-x*x+0.25d0)*log(4.d0*y*y*y-3.d0*y*y+1.25d0)
!
      RETURN
      END FUNCTION PMS
!
      FUNCTION DPDXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DPDXMS -> First derivative of p with respect to x
!
      REAL*8 DPDXMS,X,Y
!
      DPDXMS=0.5d0*(2.d0-2.d0*x)/(2.d0*x-x*x+0.25d0)*log(4.d0*y*y*y-3.d0*y*y+1.25d0)
!
      RETURN
      END FUNCTION DPDXMS
!
      FUNCTION DPDYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  DPDYMS -> First derivative of p with respect to y
!
      REAL*8 DPDYMS,X,Y
!
      DPDYMS=0.5d0*(12.d0*y*y-6.d0*y)/(4.d0*y*y*y-3.d0*y*y+1.25d0)*log(2.d0*x-x*x+0.25d0)
!
      RETURN
      END FUNCTION DPDYMS
!
! Eddy-viscosity
!
!
! Auxiliary Variables
!
      FUNCTION STRAINMS(X,Y)
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  STRAINMS -> Strain rate, S
!
      INCLUDE 'datamms.incl'
!
      REAL*8 STRAINMS,X,Y
      REAL*8 DUDXMS,DUDYMS,DVDXMS,DVDYMS
      REAL*8 U1X,U1Y,U2X,U2Y
!
      U1X=DUDXMS(X,Y)
      U1Y=DUDYMS(X,Y)
      U2X=DVDXMS(X,Y)
      U2Y=DVDYMS(X,Y)
      STRAINMS=2.D0*(U1X*U1X+U2Y*U2Y)+(U1Y+U2X)*(U1Y+U2X)
      STRAINMS=SQRT(STRAINMS)
!
      RETURN
      END FUNCTION STRAINMS
!
      FUNCTION VORTMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X      -> Horizontal coordinate
!  Y      -> Vertical coordinate
!  VORTMS -> Vorticity magnitude
!
      REAL*8 VORTMS,X,Y
      REAL*8 DUDYMS,DVDXMS
      REAL*8 U1Y,U2X
!
      U1Y=DUDYMS(X,Y)
      U2X=DVDXMS(X,Y)
      VORTMS=(U1Y-U2X)*(U1Y-U2X)
      VORTMS=SQRT(VORTMS)
!
      RETURN
      END FUNCTION VORTMS
!
      FUNCTION DVODXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  DVODXMS -> First derivatice of vorticity magnitude with respect to x
!
      REAL*8 DVODXMS,X,Y,VORT
      REAL*8 DUDYMS,DVDXMS,DUDXYMS,DVDX2MS
!
      VORT=SIGN(1.D0,DUDYMS(X,Y)-DVDXMS(X,Y))
      DVODXMS=VORT*(DUDXYMS(X,Y)-DVDX2MS(X,Y))
!
      RETURN
      END FUNCTION DVODXMS
!
      FUNCTION DVODYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  DVODYMS -> First derivatice of vorticity magnitude with respect to y
!
      REAL*8 DVODYMS,X,Y,VORT
      REAL*8 DUDYMS,DVDXMS,DUDY2MS,DVDXYMS
!
      VORT=SIGN(1.D0,DUDYMS(X,Y)-DVDXMS(X,Y))
      DVODYMS=VORT*(DUDY2MS(X,Y)-DVDXYMS(X,Y))
!
      RETURN
      END FUNCTION DVODYMS
!
      FUNCTION DVODX2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DVODX2MS -> Second derivatice of vorticity magnitude with respect to x
!
      REAL*8 DVODX2MS,X,Y,VORT
      REAL*8 DUDYMS,DVDXMS,DUDX2YMS,DVDX3MS
!
      VORT=SIGN(1.D0,DUDYMS(X,Y)-DVDXMS(X,Y))
      DVODX2MS=VORT*(DUDX2YMS(X,Y)-DVDX3MS(X,Y))
!
      RETURN
      END FUNCTION DVODX2MS
!
      FUNCTION DVODY2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DVODY2MS -> Second derivatice of vorticity magnitude with respect to y
!
      REAL*8 DVODY2MS,X,Y,VORT
      REAL*8 DUDYMS,DVDXMS,DUDY3MS,DVDXY2MS
!
      VORT=SIGN(1.D0,DUDYMS(X,Y)-DVDXMS(X,Y))
      DVODY2MS=VORT*(DUDY3MS(X,Y)-DVDXY2MS(X,Y))
!
      RETURN
      END FUNCTION DVODY2MS
!
!  One-equation turbulence models
!  Spalart & Allmaras 
      FUNCTION SMXSAMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  SMXSAMS -> Source function of x momentum equation for the Spalart & Allmaras model
!
      REAL*8 X,Y,SMXSAMS
      REAL*8 UMS,VMS,EDDYSAMS,DUDXMS,DUDYMS,DUDX2MS,DUDY2MS,DVDXMS,DPDXMS,DESADXMS,DESADYMS
      REAL*8 U1,U2,EM,CV1,CV2,CVX,DF1,DF2,DF3,DFX,DPX
!
!  X momentum
!
      U1=UMS(X,Y)
      U2=VMS(X,Y)
      EM=EDDYSAMS(X,Y)
!  Convection
      CV1=U1*DUDXMS(X,Y)
      CV2=U2*DUDYMS(X,Y)
      CVX=CV1+CV2
!  DIFUSION
      DF1=-(EMU+EM)*(DUDX2MS(X,Y)+DUDY2MS(X,Y))
      DF2=-2.D0*DESADXMS(X,Y)*DUDXMS(X,Y)
      DF3=-DESADYMS(X,Y)*(DUDYMS(X,Y)+DVDXMS(X,Y))
      DFX=DF1+DF2+DF3
!
!  PRESSURE
      DPX=DPDXMS(X,Y)
!
      SMXSAMS=CVX+DFX+DPX
!
!eca      WRITE(12,'(6(1PE14.6))') X,Y,CVX,DFX,DPX,SMXSAMS
!
      RETURN
      END FUNCTION SMXSAMS
!
      FUNCTION SMYSAMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X     -> Horizontal coordinate
!  Y     -> Vertical coordinate
!  SMYSAMS -> Source function of y momentum equation for the Spalart & Allmaras model
!
      REAL*8 X,Y,SMYSAMS
      REAL*8 UMS,VMS,EDDYSAMS,DVDXMS,DVDYMS,DVDX2MS,DVDY2MS,DUDYMS,DPDYMS,DESADXMS,DESADYMS
      REAL*8 U1,U2,EM,CV1,CV2,CVY,DF1,DF2,DF3,DFY,DPY
!
!  Y momentum
!
      U1=UMS(X,Y)
      U2=VMS(X,Y)
      EM=EDDYSAMS(X,Y)
!  CONVECTION
      CV1=U1*DVDXMS(X,Y)
      CV2=U2*DVDYMS(X,Y)
      CVY=CV1+CV2
!  DIFUSION
      DF1=-(EMU+EM)*(DVDX2MS(X,Y)+DVDY2MS(X,Y))
      DF2=-2.D0*DESADYMS(X,Y)*DVDYMS(X,Y)
      DF3=-DESADXMS(X,Y)*(DUDYMS(X,Y)+DVDXMS(X,Y))
      DFY=DF1+DF2+DF3
!
!  PRESSURE
      DPY=DPDYMS(X,Y)
!
      SMYSAMS=CVY+DFY+DPY
!
!eca      WRITE(32,'(6(1PE14.6))') X,Y,CVY,DFY,DPY,SMYSAMS
!
      RETURN
      END FUNCTION SMYSAMS
!  Menter
      FUNCTION SMXMTMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X       -> Horizontal coordinate
!  Y       -> Vertical coordinate
!  SMXMTMS -> Source function of x momentum equation for the Menter model
!
      REAL*8 X,Y,SMXMTMS
      REAL*8 UMS,VMS,EDDYMTMS,DUDXMS,DUDYMS,DUDX2MS,DUDY2MS,DVDXMS,DPDXMS,DEMTDXMS,DEMTDYMS
      REAL*8 U1,U2,EM,CV1,CV2,CVX,DF1,DF2,DF3,DFX,DPX
!
!  X momentum
!
      U1=UMS(X,Y)
      U2=VMS(X,Y)
      EM=EDDYMTMS(X,Y)
!  Convection
      CV1=U1*DUDXMS(X,Y)
      CV2=U2*DUDYMS(X,Y)
      CVX=CV1+CV2
!  DIFUSION
      DF1=-(EMU+EM)*(DUDX2MS(X,Y)+DUDY2MS(X,Y))
      DF2=-2.D0*DEMTDXMS(X,Y)*DUDXMS(X,Y)
      DF3=-DEMTDYMS(X,Y)*(DUDYMS(X,Y)+DVDXMS(X,Y))
      DFX=DF1+DF2+DF3
!
!  PRESSURE
      DPX=DPDXMS(X,Y)
!
      SMXMTMS=CVX+DFX+DPX
!
!eca      WRITE(12,'(6(1PE14.6))') X,Y,CVX,DFX,DPX,SMXMTMS
!
      RETURN
      END FUNCTION SMXMTMS
!
      FUNCTION SMYMTMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X     -> Horizontal coordinate
!  Y     -> Vertical coordinate
!  SMYMTMS -> Source function of y momentum equation for the Menter model
!
      REAL*8 X,Y,SMYMTMS
      REAL*8 UMS,VMS,EDDYMTMS,DVDXMS,DVDYMS,DVDX2MS,DVDY2MS,DUDYMS,DPDYMS,DEMTDXMS,DEMTDYMS
      REAL*8 U1,U2,EM,CV1,CV2,CVY,DF1,DF2,DF3,DFY,DPY
!
!  Y momentum
!
      U1=UMS(X,Y)
      U2=VMS(X,Y)
      EM=EDDYMTMS(X,Y)
!  CONVECTION
      CV1=U1*DVDXMS(X,Y)
      CV2=U2*DVDYMS(X,Y)
      CVY=CV1+CV2
!  DIFUSION
      DF1=-(EMU+EM)*(DVDX2MS(X,Y)+DVDY2MS(X,Y))
      DF2=-2.D0*DEMTDYMS(X,Y)*DVDYMS(X,Y)
      DF3=-DEMTDXMS(X,Y)*(DUDYMS(X,Y)+DVDXMS(X,Y))
      DFY=DF1+DF2+DF3
!
!  PRESSURE
      DPY=DPDYMS(X,Y)
!
      SMYMTMS=CVY+DFY+DPY
!
!eca      WRITE(32,'(6(1PE14.6))') X,Y,CVY,DFY,DPY,SMYMTMS
!
      RETURN
      END FUNCTION SMYMTMS
!
!  Turbulence Models
!
!  Dependent variable of the one-equation models
!
      FUNCTION EM1MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X     -> Horizontal coordinate
!  Y     -> Vertical coordinate
!  EM1MS -> Dependent variable of the model
!
      REAL*8 EM1MS,X,Y,ETA,T1
!
      ETA=SIGETA*Y/X
      T1=SQRT(2.D0)*EXP(0.5D0)*EMMAX
!
      EM1MS=T1*ETA*EXP(-ETA*ETA)
!
      RETURN
      END FUNCTION EM1MS
!
      FUNCTION DEM1DXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DEM1DXMS -> First derivative of the dependent variable of the model with respect to x
!
      REAL*8 DEM1DXMS,X,Y,ETA,T1
!
      ETA=SIGETA*Y/X
      T1=SQRT(2.D0)*EXP(0.5D0)*EMMAX/X
!
      DEM1DXMS=T1*ETA*EXP(-ETA*ETA)*(2.D0*ETA*ETA-1.D0)
!
      RETURN
      END FUNCTION DEM1DXMS
!
      FUNCTION DEM1DYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DEM1DYMS -> First derivative of the dependent variable of the model with respect to y
!
      REAL*8 DEM1DYMS,X,Y,ETA,T1
!
      ETA=SIGETA*Y/X
      T1=SQRT(2.D0)*EXP(0.5D0)*EMMAX*SIGETA/X
!
      DEM1DYMS=T1*EXP(-ETA*ETA)*(1.D0-2.D0*ETA*ETA)
!
      RETURN
      END FUNCTION DEM1DYMS
!
      FUNCTION DEM1DX2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X         -> Horizontal coordinate
!  Y         -> Vertical coordinate
!  DEM1DX2MS -> Second derivative of the dependent variable of the model with respect to x
!
      REAL*8 DEM1DX2MS,X,Y,ETA,ET2,EM1MS,T1
!
      ETA=SIGETA*Y/X
      ET2=ETA*ETA
      T1=2.D0*EM1MS(X,Y)/X/X
!
      DEM1DX2MS=T1*(ET2*(2.D0*ET2-5.D0)+1.D0)
!
      RETURN
      END FUNCTION DEM1DX2MS
!
      FUNCTION DEM1DY2MS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X         -> Horizontal coordinate
!  Y         -> Vertical coordinate
!  DEM1DY2MS -> Second derivative of the dependent variable of the model with respect to y
!
!
      REAL*8 DEM1DY2MS,X,Y,ETA,T1,ET2
!
      ETA=SIGETA*Y/X
      ET2=ETA*ETA
      T1=2.D0*SQRT(2.D0)*EXP(0.5D0)*EMMAX*(SIGETA/X)*(SIGETA/X)*EXP(-ET2)
!
      DEM1DY2MS=T1*ETA*(2.D0*ET2-3.D0)
!
      RETURN
      END FUNCTION DEM1DY2MS
!
!  Spalart & Allmaras one-equation model
      FUNCTION SSAMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X     -> Horizontal coordinate
!  Y     -> Vertical coordinate
!  SSAMS -> Source function of the transport equation of the Spalart & Allmaras model
!
      REAL*8 SSAMS,X,Y
      REAL*8 UMS,VMS,EM1MS,DEM1DXMS,DEM1DYMS,DEM1DX2MS,DEM1DY2MS
      REAL*8 VORTMS
      REAL*8 U1,U2,EMSA
      REAL*8 DEMDX,DEMDY,DEMDX2,DEMDY2,DESADX,DESADY,DESADX2,DESADY2
      REAL*8 CV1,DF1,CP1,CD1,CW1,YLOC
      REAL*8 STR,FV1,FV2,DYP,R,G,FW,SIG,EMT
!
      YLOC=MAX(1.D-40,Y)
      YLOC=YLOC*YLOC
!
!  Spalart & Allmaras one-equation turbulence model
!  
      U1  =UMS(X,Y)
      U2  =VMS(X,Y)
      EMSA=EM1MS(X,Y)
!
!  First and second derivatives of mu_tilde
!
      DESADX  =DEM1DXMS(X,Y)
      DESADY  =DEM1DYMS(X,Y)
      DESADX2 =DEM1DX2MS(X,Y)
      DESADY2 =DEM1DY2MS(X,Y)
!
!  Convection
!
      CV1=U1*DESADX+U2*DESADY
!
!  Diffusion
!
      SIG=2.D0/3.D0
      DF1=(EMU+EMSA)*(DESADX2+DESADY2)
      DF1=DF1+1.622D0*(DESADX*DESADX+DESADY*DESADY)
      DF1=-DF1/SIG
!  Production
      EMT=EMSA/EMU
      FV1=EMSA**3/(EMSA**3+(7.1D0*EMU)**3)
      FV2=1.D0-EMT/(EMT*FV1+1.D0)
      DYP=EMSA/0.41D0/0.41D0/YLOC
      STR=VORTMS(X,Y)+DYP*FV2
      CP1=-0.1355D0*STR*EMSA
!  Dissipation
      CW1=0.1355D0/0.41D0/0.41D0+1.622D0/SIG
      R=DYP/STR
      G=R*(1.D0+0.3D0*(R**5-1.D0))
      FW=65.D0/(G**6+64.D0)
      FW=G*(FW**(1.D0/6.D0))
      CD1=CW1*FW*EMSA*EMSA/YLOC
!
      SSAMS=CV1+DF1+CP1+CD1
!
!eca      WRITE(42,'(7(1PE14.6))') X,Y,CV1,DF1,CP1,CD1,SSAMS
!
      RETURN
      END FUNCTION SSAMS
!
      FUNCTION EDDYSAMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  EDDYSAMS -> Eddy-viscosity for the Spalart & Allmaras model
!
      REAL*8 EDDYSAMS,EM1MS,FV1SAMS,EMSA,X,Y
!
      EMSA=EM1MS(X,Y)
      EDDYSAMS=FV1SAMS(EMSA)*EMSA
!
      RETURN
      END FUNCTION EDDYSAMS
!
      FUNCTION DESADXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DESADXMS -> First derivative of the eddy-viscosity with respect to x for the Spalart & Allmaras model
!
      REAL*8 DESADXMS,DEM1DXMS,EM1MS,DFV1SAMS,FV1SAMS,EMSA,X,Y
!
      EMSA=EM1MS(X,Y)
!
      DESADXMS=(FV1SAMS(EMSA)+DFV1SAMS(EMSA)*EMSA)*DEM1DXMS(X,Y)
!
      RETURN
      END FUNCTION DESADXMS
!
      FUNCTION DESADYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DESADYMS -> First derivative of the eddy-viscosity with respect to y for the Spalart & Allmaras model
!
      REAL*8 DESADYMS,DEM1DYMS,EM1MS,DFV1SAMS,FV1SAMS,EMSA,X,Y
!
      EMSA=EM1MS(X,Y)
!
      DESADYMS=(FV1SAMS(EMSA)+DFV1SAMS(EMSA)*EMSA)*DEM1DYMS(X,Y)
!
      RETURN
      END FUNCTION DESADYMS
!
      FUNCTION FV1SAMS(EM)
!
      INCLUDE 'datamms.incl'
!
!  EM      -> Dependent Variable of the Spalart & Allmaras model, nu_tilde
!  FV1SAMS -> Damping function
!
      REAL*8  FV1SAMS,EM,CV1
!
      CV1=(7.1D0*EMU)**3
      FV1SAMS=EM*EM*EM/(EM*EM*EM+CV1)
!
      RETURN
      END FUNCTION FV1SAMS
!
      FUNCTION DFV1SAMS(EM)
!
      INCLUDE 'datamms.incl'
!
!
!  EM       -> Dependent Variable of Spalart & Allmaras model
!  DFV1SAMS -> First derivative of the damping function with respect to nu_tilde
!
      REAL*8  DFV1SAMS,CV1,EM
!
      CV1=(7.1D0*EMU)**3
      DFV1SAMS=3.D0*EM*EM*CV1/(EM*EM*EM+CV1)/(EM*EM*EM+CV1)
!
      RETURN
      END FUNCTION DFV1SAMS
!
!  Menter one-equation model
!
      FUNCTION SMTMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X     -> Horizontal coordinate
!  Y     -> Vertical coordinate
!  SMTMS -> Source function of the transport equation of the Menter model
!
      REAL*8 SMTMS,X,Y
      REAL*8 UMS,VMS,EM1MS,DEM1DXMS,DEM1DYMS,DEM1DX2MS,DEM1DY2MS
      REAL*8 STRAINMS,EDDYMTMS,DEDMTMS,DEDMT2MS
      REAL*8 DUDXMS,DUDYMS,DUDX2MS,DUDY2MS,DUDXYMS,DVDXMS,DVDYMS,DVDX2MS,DVDY2MS,DVDXYMS
      REAL*8 U1DX,U1DY,U1DX2,U1DY2,U1DXY2,U2DX,U2DY,U2DX2,U2DY2,U2DXY2
      REAL*8 U1,U2,EMTU,EMMT
      REAL*8 DEMDX,DEMDY,DEMDX2,DEMDY2,DEMTDX,DEMTDY,DEMTDX2,DEMTDY2
      REAL*8 CV1,DF1,CP1,CD1
      REAL*8 STR,FD1,SIG,EMT,DSDX,DSDY,DSDT,EKEP,EPBB,EP1E
!
! Menter one-equation turbulence model
!  
      U1  =UMS(X,Y)
      U2  =VMS(X,Y)
      EMMT=EM1MS(X,Y)
      EMTU=EDDYMTMS(X,Y)
!
!  First and second derivatives of mu_tilde
!
      DEMTDX  =DEM1DXMS(X,Y)
      DEMTDY  =DEM1DYMS(X,Y)
      DEMTDX2 =DEM1DX2MS(X,Y)
      DEMTDY2 =DEM1DY2MS(X,Y)
!
!  Convection
!
      CV1=U1*DEMTDX+U2*DEMTDY
!
!  Diffusion
!
      SIG=1.D0
      DF1=-(EMU+EMMT/SIG)*(DEMTDX2+DEMTDY2)
      DF1=DF1-(DEMTDX*DEMTDX+DEMTDY*DEMTDY)/SIG
!  Production
      FD1=(EMTU+EMU)/(EMMT+EMU)
      STR=STRAINMS(X,Y)
      CP1=-0.144D0*FD1*STR*EMMT
!  Dissipation
      U1DX  =DUDXMS(X,Y)
      U1DY  =DUDYMS(X,Y)
      U1DX2 =DUDX2MS(X,Y)
      U1DY2 =DUDY2MS(X,Y)
      U1DXY2=DUDXYMS(X,Y)
      U2DX  =DVDXMS(X,Y)
      U2DY  =DVDYMS(X,Y)
      U2DX2 =DVDX2MS(X,Y)
      U2DY2 =DVDY2MS(X,Y)
      U2DXY2=DVDXYMS(X,Y)
!
      DSDX=4.D0*(U1DX*U1DX2+U2DY*U2DXY2)+2.D0*(U1DY+U2DX)*(U1DXY2+U2DX2)
      DSDY=4.D0*(U1DX*U1DXY2+U2DY*U2DY2)+2.D0*(U1DY+U2DX)*(U1DY2+U2DXY2)
      DSDT=(DSDX*DSDX+DSDY*DSDY)/(4.D0*STR*STR)
      EKEP=EMMT*EMMT*DSDT/STR/STR
      EPBB=DEMTDX*DEMTDX+DEMTDY*DEMTDY
      EP1E=7.D0*EPBB*TANH(EKEP/(7.D0*EPBB))
      CD1 =1.862D0*EP1E
!
      SMTMS=CV1+DF1+CP1+CD1
!
!eca      WRITE(42,'(7(1PE14.6))') X,Y,CV1,DF1,CP1,CD1,SMTMS
!
      RETURN
      END FUNCTION SMTMS
!
      FUNCTION EDDYMTMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  EDDYMTMS -> Eddy-viscosity for the Menter model
!
      REAL*8 EDDYMTMS,EM1MS,D2MTMS,EMMT,X,Y
!
      EMMT=EM1MS(X,Y)
      EDDYMTMS=D2MTMS(EMMT)*EMMT
!
      RETURN
      END FUNCTION EDDYMTMS
!
      FUNCTION DEMTDXMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DEMTDXMS -> First derivative of the eddy-viscosity with respect to x for the Menter model
!
      REAL*8 DEMTDXMS,DEM1DXMS,EM1MS,DD2MTMS,D2MTMS,EMMT,X,Y
!
      EMMT=EM1MS(X,Y)
!
      DEMTDXMS=(D2MTMS(EMMT)+DD2MTMS(EMMT)*EMMT)*DEM1DXMS(X,Y)
!
      RETURN
      END FUNCTION DEMTDXMS
!
      FUNCTION DEMTDYMS(X,Y)
!
      INCLUDE 'datamms.incl'
!
!  X        -> Horizontal coordinate
!  Y        -> Vertical coordinate
!  DEMTDYMS -> First derivative of the eddy-viscosity with respect to y for the Menter model
!
      REAL*8 DEMTDYMS,DEM1DYMS,EM1MS,DD2MTMS,D2MTMS,EMMT,X,Y
!
      EMMT=EM1MS(X,Y)
!
      DEMTDYMS=(D2MTMS(EMMT)+DD2MTMS(EMMT)*EMMT)*DEM1DYMS(X,Y)
!
      RETURN
      END FUNCTION DEMTDYMS
!
      FUNCTION D2MTMS(EM)
!
      INCLUDE 'datamms.incl'
!
!  EM     -> Dependent Variable of the Menter model, nu_tilde
!  D2MTMS -> Damping function
!
      REAL*8  D2MTMS,EM,CV1,CDUM
!
      CV1 =13.D0*0.41D0*EMU
      CDUM=(EM/CV1)**2
      D2MTMS=1.d0-EXP(-CDUM)
!
      RETURN
      END FUNCTION D2MTMS
!
      FUNCTION DD2MTMS(EM)
!
      INCLUDE 'datamms.incl'
!
!  EM        -> Dependent Variable of the Menter model
!  DD2MTMSMS -> First derivative of the damping function with respect to nu_tilde
!
      REAL*8  DD2MTMS,CV1,EM,CDUM
!
      CV1    =13.D0*0.41D0*EMU
      CDUM   =EM/CV1
      DD2MTMS=2.D0*CDUM*EXP(-CDUM*CDUM)/CV1
!
      RETURN
      END FUNCTION DD2MTMS
!
!  Erf function
!
      function derfc(x)
!
      implicit none
!
      real*8 derfc,derf,x,y
      real*8 pv,ph,p0,p1,p2,p3,p4,p5,p6,p7
      real*8 q0,q1,q2,q3,q4,q5,q6,q7
!
      parameter(pv= 1.26974899965115684d+01, &
                ph= 6.10399733098688199d+00, &
                p0= 2.96316885199227378d-01, &
                p1= 1.81581125134637070d-01, &
                p2= 6.81866451424939493d-02, &
                p3= 1.56907543161966709d-02, &
                p4= 2.21290116681517573d-03, &
                p5= 1.91395813098742864d-04, &
                p6= 9.71013284010551623d-06, &
                p7= 1.66642447174307753d-07)
      parameter(q0= 6.12158644495538758d-02, &
                q1= 5.50942780056002085d-01, &
                q2= 1.53039662058770397d+00, &
                q3= 2.99957952311300634d+00, &
                q4= 4.95867777128246701d+00, &
                q5= 7.41471251099335407d+00, &
                q6= 1.04765104356545238d+01, &
                q7= 1.48455557345597957d+01)
      y=x*x
      y=exp(-y)*x*(p7/(y+q7)+p6/(y+q6) &
        +p5/(y+q5)+p4/(y+q4)+p3/(y+q3) &
        +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))
      if(x.lt.ph) y=y+2/(exp(pv*x)+1)
      derfc=y
      RETURN
      end function derfc
!
      function derf(x)
!
      implicit none
!
      real*8 derf,derfc,y,x
      real*8 p0,p1,p2,p3,p4,p5
!
      parameter(p0= 1.12837916709551257d+00, &
                p1=-3.76126389031833602d-01, &
                p2= 1.12837916706621301d-01, &
                p3=-2.68661698447642378d-02, &
                p4= 5.22387877685618101d-03, &
                p5=-8.49202435186918470d-04)
      y=abs(x)
      if(y.gt.0.125d0) then
        derf=sign(1-derfc(y),x)
      else
        y=x*x
        derf=(((((p5*y+p4)*y+p3)*y+p2)*y+p1)*y+p0)*x
      endif
      RETURN
      end function derf
      
