!
!   Velocity Components
!
!   u velocity component
!   
      FUNCTION UBSINLET(Y)
!
!   Y        -> Vertical coordinate at the inlet 1. < y < 9.
!   UBSINLET -> Horizontal velocity at the inlet
!
!   Three-layer profile
!
      IMPLICIT NONE
!
      REAL*8 UBSINLET,y,delta,ushear,rey,ys,eta,eta0,eta1,rn,utest,dudy
      REAL*8 yplus,xks,phi1,phi2,phi3
!
      delta =1.98834554128594d0
      ushear=3.87298334620742d-2
      rey   =5.d4
      eta0  =25.d0/ushear/rey/delta
!
      eta1 =0.3d0
      rn   =0.141919280528867d0
      utest=eta1**rn
      dudy =(1.d0-eta1)*rn*(eta1**(rn-1.))
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        ubsinlet=0.d0
        return
      endif
!
      ys =min(y-1.d0,9.d0-y)
!
      eta  =ys/delta
!
      if(eta.le.eta0) then
        yplus   = ys*ushear*rey
        ubsinlet=ushear*(5.53778847303681d0                                        &
     &          *atan((yplus-4.07894253978259d0)/8.35527362869765d0)               &
     &          +0.5d0*1.73729268078011d0                                          &
     &          *log((yplus+10.5969094698091d0)**4.80784512273279d0                &
     &          /(yplus*(yplus-2.d0*4.07894253978259d0)+86.4483696532584d0))       &
     &          -3.46968285422468)+(1.754921261489573D-2*(eta*eta*(3.d0-2.d0*eta)) &
     &          +9.446300844408334D-2*eta*eta*(1.d0-eta))
        ubsinlet=max(ubsinlet,0.d0)
      endif
!
      if(eta.gt.eta0.and.eta.le.eta1) then
        ubsinlet=eta**rn
      endif
!
      if(eta.gt.eta1.and.eta.lt.1.d0) then
        xks=(eta-eta1)/(1.d0-eta1)
        phi1=xks*xks*(2.d0*xks-3.d0)+1.d0
        phi2=xks*xks*(3.d0-2.d0*xks)
        phi3=xks*xks*(xks-2.d0)+xks
        ubsinlet=utest*phi1+phi2+dudy*phi3
      endif
!
      if(eta.ge.1.d0) then
        ubsinlet=1.d0
      endif
!
      return
      END FUNCTION UBSINLET
!
!
!   u velocity component
!   
      FUNCTION VBSINLET(Y)
!
!   Y        -> Vertical coordinate at the inlet 1. < y < 9.
!   VBSINLET -> Horizontal velocity at the inlet
!
      IMPLICIT NONE
!
      REAL*8 VBSINLET,Y
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        vbsinlet=0.d0
        return
      endif
!
      vbsinlet=0.d0
!
      return
      END FUNCTION VBSINLET
!
!   TURBULENCE QUANTITIES
!
!   eddy-viscosity
!   
      FUNCTION EDDYBSINLET(Y)
!
!   Y           -> Vertical coordinate at the inlet 1. < y < 9.
!   EDDYBSINLET -> Horizontal velocity at the inlet
!
      IMPLICIT NONE
!
      REAL*8 EDDYBSINLET,y,tkbsinlet,epsbsinlet
      REAL*8 tks,eps,rey,ushear,emu,ys,y2p,rkp,rleps,futml
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        eddybsinlet=0.d0
        return
      endif
!
      rey   =5.d4
      ushear=3.87298334620742d-2
      EMU   =1.D0/REY
!
      ys =min(y-1.d0,9.d0-y)
      if(ys.lt.1.d-20) then
        eddybsinlet=0.d0
        return
      endif
!
      tks=tkbsinlet(y)
      eps=epsbsinlet(y)
!
      y2p=ushear*ys/emu
      RKP=SQRT(tks)*ys/emu
      rleps=1.d0-EXP(-rkp/70.d0)
      rkp  =1.d0-EXP(-rkp/5.087374D0)
      FUTML=rleps/rkp
      eddybsinlet=0.09d0*futml*tks*tks/eps
!
      RETURN
      END FUNCTION EDDYBSINLET
!
!   Turbulence kinetic energy
!   
      FUNCTION TKBSINLET(Y)
!
!   Y         -> Vertical coordinate at the inlet 1. < y < 9.
!   TKBSINLET -> Turbulence kinetic energy
!
      IMPLICIT NONE
!
      REAL*8 TKBSINLET,y
      REAL*8 delta,ushear,rey,emu,emlim,rkext,ys,y2p,eta,f1,f2
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        tkbsinlet=0.d0
        return
      endif
!
      delta =1.98834554128594
      rey   =5.d4
      ushear=3.87298334620742d-2
      EMU   =1.D0/REY
!
      emlim=3.3d0*ushear**2
      rkext=0.1d0*emu 
!
      ys =min(y-1.d0,9.d0-y)
      y2p=ushear*ys/emu
!
      if(y2p.lt.5)                 tkbsinlet=0.05D0*y2p*y2p*ushear**2
      if(y2p.ge.5.and.y2p.lt.15.)  tkbsinlet=(1.25D0+0.325D0*(y2p-5.D0))*ushear**2
      if(y2p.ge.15.and.y2p.lt.60.) then
        eta=(y2p-15.d0)/45.d0
        f2 =3.d0*eta*eta-2.d0*eta*eta*eta
        f1 =1.d0-f2
        tkbsinlet=(4.5d0*f1+3.3d0*f2)*ushear**2
      endif
!
      if(y2p.gt.60) then
        eta=ys/delta
        if(eta.le.0.15d0) then
          tkbsinlet=emlim
        else
          eta=(eta-0.15d0)/(1.d0-0.15d0)
          eta=min(eta,1.d0)
          f2 =3.d0*eta*eta-2.d0*eta*eta*eta
          f1 =1.d0-f2
          tkbsinlet=emlim*f1+rkext*f2
        endif
      endif
!
      RETURN
      END FUNCTION TKBSINLET
!
!   Epsilon of two-layer model
!   
      FUNCTION EPSBSINLET(Y)
!
!   Y          -> Vertical coordinate at the inlet 1. < y < 9.
!   EPSBSINLET -> Epsilon of two-layer model
!
      IMPLICIT NONE
!
      REAL*8 EPSBSINLET,y,tkbsinlet
      REAL*8 delta,ushear,rey,emu,emlim,rkext,epslim,ys,ks,rkp,rleps,epsdif
      REAL*8 eta,f1,f2,f3
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        epsbsinlet=0.d0
        return
      endif
!
      delta =1.98834554128594
      rey   =5.d4
      ushear=3.87298334620742d-2
      EMU   =1.D0/REY
!
      emlim=3.3d0*ushear**2
      rkext=0.1d0*emu 
      epslim=0.09d0*rkext*rkext/(0.01d0*emu)
!
      ys =min(y-1.d0,9.d0-y)
      ys =max(ys,1.d-10)
      ks =tkbsinlet(y)
!
      RKP  =SQRT(emlim)*0.15d0*delta/emu
      RLEPS=2.543687D0*0.15d0*delta*(1.d0-exp(-rkp/5.087374d0))
      emlim=(emlim**1.5)/rleps
      epsdif=epslim-emlim
!
      eta=ys/delta
      if(eta.le.0.15d0) then
        RKP  =SQRT(ks)*ys/emu
        RLEPS=2.543687D0*ys*(1.d0-exp(-rkp/5.087374d0))
        epsbsinlet=(ks**1.5)/max(rleps,1.d-40)
      else
        eta       =(eta-0.15d0)/(1.d0-0.15d0)
        eta       =min(eta,1.d0)
        f2        =3.d0*eta*eta-2.d0*eta*eta*eta
        f1        =1.d0-f2
        f3        = eta-2.d0*eta*eta+eta*eta*eta
        epsbsinlet=emlim*f1+epslim*f2+epsdif*f3
      endif
!
      RETURN
      END FUNCTION EPSBSINLET
!
!   Omega of for k-w models
!   
      FUNCTION OMBSINLET(Y)
!
!   Y         -> Vertical coordinate at the inlet 1. < y < 9.
!   OMBSINLET -> Omega of for k-w models
!
      IMPLICIT NONE
!
      REAL*8 OMBSINLET,y,tkbsinlet,eddybsinlet
      REAL*8 epslim,delta,ushear,emu,rey,ys,y2p,eta,ems,tks
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        ombsinlet=0.d0
        return
      endif
!
      epslim=10.d0
      delta =1.98834554128594
      rey   =5.d4
      ushear=3.87298334620742d-2
      EMU   =1.D0/REY
!
      ys =min(y-1.d0,9.d0-y)
      ys =max(ys,1.d-40)
      y2p=ushear*ys/emu
!
      if(y2p.lt.2.5) then
        ombsinlet=6.D0/0.075D0*EMU/ys**2
      else
        ems=eddybsinlet(y)
        tks=tkbsinlet(y)
        ombsinlet=tks/ems
      endif
      eta=ys/delta
      if(eta.ge.1.d0) ombsinlet=epslim
!
      RETURN
      END FUNCTION OMBSINLET
!
!   Dependent variable of Spalart & Allmaras one-equation model
!   
      FUNCTION EMSABSINLET(Y)
!
!   Y           -> Vertical coordinate at the inlet 1. < y < 9.
!   EMSABSINLET -> Dependent variable of Spalart & Allmaras model
!
      IMPLICIT NONE
!
      REAL*8 EMSABSINLET,y,eddybsinlet
      real*8 rey,emu,ems,cdum,emtu,rloa,floa,rlob,flob,rloc,rlo3,floc
      INTEGER nitl,nitr,kw
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        emsabsinlet=0.d0
        return
      endif
!
      rey   =5.d4
      EMU   =1.D0/REY
      ems=eddybsinlet(y)
      if(ems.lt.1.d-40) then
        emsabsinlet=0.d0
        return
      endif
!
      CDUM=7.1D0**3
!
      EMTU=EMS/EMU
      RLOA=0.D0
      FLOA=EMTU
      NITL=0
      NITR=0
      DO KW=1,10
         RLOB=EMU*10**(KW-1)
         RLO3=(RLOB/EMU)**3
         FLOB=EMTU-RLOB*RLO3/(RLO3+CDUM)/EMU
         IF(FLOA*FLOB.LE.0) GOTO 301
         RLOA=RLOB
         FLOA=FLOB
      ENDDO
  301 RLOC=RLOA-FLOA*(RLOB-RLOA)/(FLOB-FLOA)
      RLO3=(RLOC/EMU)**3
      FLOC=EMTU-RLOC*RLO3/(RLO3+CDUM)/EMU
      IF(ABS(FLOC).GT.1.E-11) THEN
        IF(FLOA*FLOC.GT.0) THEN
          FLOA=FLOC
          RLOA=RLOC
          NITL=NITL+1
          IF(NITL.GT.1) THEN
            FLOB=FLOB/2.d0
            NITL=0
          ENDIF
          NITR=0
        ELSE
          FLOB=FLOC
          RLOB=RLOC
          NITR=NITR+1
          NITL=0
          IF(NITR.GT.1) THEN
            FLOA=FLOA/2.d0
            NITR=0
          ENDIF
        ENDIF
        GOTO 301
      ENDIF
      emsabsinlet=RLOC
!
      RETURN
      END FUNCTION EMSABSINLET
!
!   Dependent variable of Menter one-equation model
!   
      FUNCTION EMMTBSINLET(Y)
!
!   Y           -> Vertical coordinate at the inlet 1. < y < 9.
!   EMSABSINLET -> Dependent variable of Menter model
!
      IMPLICIT NONE
!
      REAL*8 EMMTBSINLET,y,eddybsinlet
      real*8 rey,emu,ems,cdiv,bmax,emtu,rloa,floa,rlob,rhsn,rlo4,flob,rloc,floc
      integer nitl,nitr,kw
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        emmtbsinlet=0.d0
        return
      endif
!
      rey   =5.d4
      EMU   =1.D0/REY
      ems=eddybsinlet(y)
      if(ems.lt.1.d-40) then
        emmtbsinlet=0.d0
        return
      endif
!
      CDIV=13.d0*0.41d0*EMU
      BMAX=30.D0
      EMTU=EMS/EMU
      RLOA=0.
      FLOA=-EMTU
      NITL=0
      NITR=0
      DO KW=1,10
         RLOB=EMU*10**KW
         RHSN=RLOB/CDIV
         RLO4=MIN(BMAX,RHSN*RHSN)
         FLOB=(1.D0-RLOB*EXP(-RLO4))*RLOB/EMU-EMTU
         IF(FLOB*FLOA.LE.0.) GOTO 301
         RLOA=RLOB
         FLOA=FLOB
      ENDDO
  301 RLOC=RLOA-FLOA*(RLOB-RLOA)/(FLOB-FLOA)
      RHSN=RLOC/CDIV
      RLO4=MIN(BMAX,RHSN*RHSN)
      FLOC=(1.-RLOC*EXP(-RLO4))*RLOC/EMU-EMTU
      IF(ABS(FLOC).GT.1.E-9) THEN
        IF(FLOA*FLOC.GT.0.D0) THEN
          FLOA=FLOC
          RLOA=RLOC
          NITL=NITL+1
          IF(NITL.GT.1) THEN
            FLOB=FLOB/2.d0
            NITL=0
          ENDIF
          NITR=0
        ELSE
          FLOB=FLOC
          RLOB=RLOC
          NITR=NITR+1
          NITL=0
          IF(NITR.GT.1) THEN
            FLOA=FLOA/2.d0
            NITR=0
          ENDIF
        ENDIF
        GOTO 301
      ENDIF
      EMMTBSINLET=RLOC
!
      RETURN
      END FUNCTION EMMTBSINLET
!
!   Epsilon of Chien's model
!   
      FUNCTION EPSCHBSINLET(Y)
!
!   Y            -> Vertical coordinate at the inlet 1. < y < 9.
!   EPSCHBSINLET -> Epsilon of Chien's model
!
      IMPLICIT NONE
!
      REAL*8 EPSCHBSINLET,y,tkbsinlet,eddybsinlet
      REAL*8 tks,ems,ys,futm,ushear,rey,emu,y2p
!
      if(y.lt.1.d0.or.y.gt.9.d0) then
        write(6,'('' y coordinate of inlet node out of range, 1<y<9, y='',F7.1)') y
        epschbsinlet=0.d0
        return
      endif
!
      rey   =5.d4
      ushear=3.87298334620742d-2
      EMU   =1.D0/REY
!
      ys =min(y-1.d0,9.d0-y)
      ys =max(ys,1.d-40)
      y2p=ushear*ys/emu
!
      tks=tkbsinlet(y)
      ems=eddybsinlet(y)
      futm=1.d0-exp(-0.0115d0*y2p)
      epschbsinlet=0.09d0*futm*tks*tks/max(ems,1.d-40)
!
      RETURN
      END FUNCTION EPSCHBSINLET
