      PROGRAM RDHW
C
C     This program reads in data from the hotwire data files,
C     P*U.DAT, P*UV.DAT, and P*UW.DAT.  All data are stored in arrays 
C     as described below.  
C
C     PORTN       :  The number of the port at which the data in
C                    the file to be read was taken.
C     FTYPE       :  An integer value corresponding to the type of
C                    hotwire configuration used to take the data.
C     FILENAME    :  The name of the data file to be read.
C     UTAU        :  Friction velocity 
C     DEL99       :  Boundary layer thickness 
C     INDEX       :  Number of the data point
C     NBEG        :  Index of the first data point in the file
C     NEND        :  Index of the last data point in the file
C     NWIRE       :  Number of individual wires used
C     NPROBE      :  Number of probes used
C          Thus, if NWIRE = 1 and NPROBE =1 , a single normal
C          wire was used.  If NWIRE = 2, and NPROBE = 1, a
C          crossed-wire probe was used.  
C     Y           :  Height (in meters) of the center of the active 
C                    length of the wire(s) from the test wall of 
C                    the tunnel.
C
C          In all hot wire files, u is the velocity in the
C          streamwise direction.  The freestream velocity is also
C          in the streamwise direction.  v is the velocity normal
C          to the test wall and perpendicular to the freestream
C          velocity.  w is the velocity parallel to the test wall
C          and perpendicular to the freestream velocity.  All
C          velocities are decomposed into an average and a
C          fluctuating component:
C                u = U + u'  ;  v = V + v'  ;  w = W + w'
C        
C     UBAR        :  U
C     VBAR        :  V
C     UPR2        :  average value of u'u'
C     UPR3        :  average value of u'u'u'
C     UPR4        :  average value of u'u'u'u'
C     VPR2        :  average value of v'v'
C     VPR3        :  average value of v'v'v'
C     UPRVPR      :  average value of u'v'
C     UPR2VPR     :  average value of u'u'v'
C     UPRVPR2     :  average value of u'v'v'
C           For the files P*UW.DAT, which correspond to data taken
C           using a u,w crossed-wire probe, the same variable names
C           as above still apply.  Simply replace V with W, and
C           replace v' with w'.       
C                    
      INTEGER*2 I, LUIN /9/, PORTN, FTYPE, INDEX, NBEG, NEND, 
     +          NWIRE, NPROBE, LUKEY /5/, LUCRT /6/, NPTS
      REAL*4    UTAU, DEL99, Y(40), UBAR(40), UPR2(40), UPR3(40),
     +          UPR4(40), VBAR(40), VPR2(40), VPR3(40), UVPR(40),
     +          UPR2VPR(40), UPRVPR2(40)
      CHARACTER FILENAME*8
C
  100 FORMAT (' At what port was the survey taken? ',$)
  200 FORMAT (' Is the survey : ',/,
     +        '      a single normal wire, enter 1',/,
     +        '      a u,v crossed wire, enter 2',/,
     +        '      a u,w crossed wire, enter 3',/,
     +        ' --> ',$)
  500 FORMAT (I4)
  600 FORMAT ( 2(G11.4, X), 2(I3, X), I5, X, I2)
  700 FORMAT (' ', I5,  5(E13.6, 2X) )
  800 FORMAT (' ', I5, 11(E13.6, 2X) )
C
      WRITE (LUCRT, 100)
      READ  (LUKEY, 500) PORTN
      WRITE (LUCRT, 200)
      READ  (LUKEY, 500) FTYPE
C
      IF (FTYPE .EQ. 1) THEN
           FILENAME = 'P'//CHAR(PORTN+48)//'U.DAT'
        ELSEIF (FTYPE .EQ. 2) THEN
           FILENAME = 'P'//CHAR(PORTN+48)//'UV.DAT'
        ELSEIF (FTYPE .EQ. 3) THEN
           FILENAME = 'P'//CHAR(PORTN+48)//'UW.DAT'
       ENDIF
C
      OPEN (UNIT=LUIN, FILE=FILENAME, STATUS='OLD', READONLY)
      READ (LUIN, 600) UTAU, DEL99, NBEG, NEND, NWIRE, NPROBE
      NPTS = NEND - NBEG + 1
      DO 900 I = 1, NPTS
        IF (FTYPE .EQ. 1) THEN
            READ (LUIN, 700) INDEX, Y(I), UBAR(I), UPR2(I),
     +                       UPR3(I), UPR4(I)
          ELSE
            READ (LUIN, 800) INDEX, Y(I), UBAR(I), VBAR(I), UPR2(I), 
     +                       UVPR(I), VPR2(I), UPR3(I),  UPR2VPR(I), 
     +                       UPRVPR2(I), VPR3(I), UPR4(I)
         ENDIF
  900  CONTINUE
C
      STOP
      END
