% plot the profile data for the UQ experiment inflow
% all of the profiles are extracted at a streamwise position 35mm upstream
% of the compression ramp foot
%
% put the inletProfiles.mat data file in the same directory as this script
%

clear all; close all; clc

% load data file
load('inletProfiles.mat')

% line formatting
linespec = {'x-';'-o';'-s';'-v';'-p'};
linecolors = [0; 0.15; 0.3; 0.45; 0.6]*[1 1 1];
lineweight = 1.5;
mark_size = 8;

% plot profiles
for j = 1:numel(Z)

    % U mean
    figure(1); hold on
    plot(Y{j},U{j},linespec{j},'Color',linecolors(j,:),...
        'MarkerSize', mark_size,'LineWidth',lineweight)
    
    % V mean
    figure(2); hold on
    plot(Y{j},V{j},linespec{j},'Color',linecolors(j,:),...
        'MarkerSize', mark_size,'LineWidth',lineweight)
    
    % u'
    figure(3); hold on
    plot(Y{j},uprime{j},linespec{j},'Color',linecolors(j,:),...
        'MarkerSize', mark_size,'LineWidth',lineweight)
    
    % v'
    figure(4); hold on
    plot(Y{j},vprime{j},linespec{j},'Color',linecolors(j,:),...
        'MarkerSize', mark_size,'LineWidth',lineweight)
    
    % u'v'
    figure(5); hold on
    plot(Y{j},-uprimevprime{j},linespec{j},'Color',linecolors(j,:),...
        'MarkerSize', mark_size,'LineWidth',lineweight)

end

% format plots
set(0, 'DefaultAxesFontSize', 20);
figure_size_and_position = [100 100 600 650];
legend_data = {'$z$ = 21mm'; '$z$ = 8mm'; '$z$ = 5.5mm'; '$z$ = 4mm'; '$z$ = 2mm'};
figure_color = 'w';
legend_fsize = 14;

for j = 1:5
    figure(j)
    xlabel('$y$ [mm]','interpreter','latex')
    set(gcf,'color',figure_color)
    set(gcf,'Units','Pixels','Position',figure_size_and_position)
    box on; grid on
    h_leg = legend(legend_data);
    set(h_leg,'interpreter','latex','FontSize',legend_fsize,'color',figure_color)
    if j == 1 | j == 2
        set(h_leg,'position',[0.72 0.23 0.1 0.1])
    end
end

figure(1)
ylabel('$U$ [m/s]','interpreter','latex')
ylim([0 550])

figure(2)
ylabel('$V$ [m/s]','interpreter','latex')
ylim([-20 20])

figure(3)
ylabel('$u''$ [m/s]','interpreter','latex')
ylim([0 90])

figure(4)
ylabel('$v''$ [m/s]','interpreter','latex')
ylim([0 30])

figure(5)
ylabel('$-\langle u''v''\rangle$ [m$^2$/s$^2$]','interpreter','latex')
ylim([-50 400])
