C***********************************************************************
      Program VDIIfp
C***********************************************************************

C     Input Mach number, Plate Length-meters, Unit Reynolds No
C           Twall, T0, Tedge

C     Obtain ...
C***********************************************************************
      implicit none
      integer ipts,npts_KS,npts_White

      Real*8 ReT(30),CfKS(30),CfKSI(30)
      Real*8 ReX(30),CfWh(30), CfWhI(30)
      Real*8 UGasConst, RMolWt
      Real*8 Gamma,RGas,Cp,Cp0,T0
      Real*8 RMach,UEdge,TEdge,DEdge,DVisEdge
      Real*8 TWall,DWall,DVisWall
      Real*8 Taw, Haw
      Real*8 CpEdge, CpWall, Hedge, HWall, HTotal
      Real*8 ReU      !unit Reynolds number /meter
      Real*8 EntropyEdge, EntropyWall
      Real*8 Xm, Tau

      UGasConst = 8314.3d0  !Universal Gas Const
      RMolWt    = 28.96d0   !air
      Gamma= 1.4d0
      RGas = UGasConst/RMolWt    !287.1d0
      Cp0  = RGas*Gamma/(Gamma-1.0d0)   !Cp0  = 1004.4d0

      RMach = 4.98
      ReU   =37.d6
      TWall = 300.0d0
      TEdge = 68.79d0

      Write(6,*) "RMach, ReU"
      Read(5,*) RMach, ReU 
      Write(6,*) "TWall, TEdge"
      Read(5,*) TWall, TEdge

C     FreeStream Velocity, UEdge, from TEdge and Mach Number
C     FreeStream Density,  DEdge, from UEdge, TEdge, ViscEdge, ReU
C     obtain UEdge, wall density and visc, edge density and visc

      CpEdge = RGas*Gamma/(Gamma-1.0d0)
      HEdge = CpEdge*TEdge
      EntropyEdge = 0.0d0
      CpWall = RGas*Gamma/(Gamma-1.0d0)
      HWall  = CpWall*TWall
      EntropyWall = 0.0d0

      UEdge = RMach*dsqrt(Gamma*RGas*TEdge)
C     Call CAEAir(TEdge,CpEdge,HEdge,EntropyEdge)
      Call ViscAir(TEdge,DVisEdge)
      DEdge = ReU*DVisEdge/UEdge

C     Wall density and visc

      DWall = DEdge*TEdge/TWall
      Call ViscAir(TWall,DVisWall)
C     Call CAEAir(TWall,CpWall,HWall,EntropyWall)

      HTotal = HEdge + 0.5d0*UEdge*UEdge

C     Taw from T0, TEdge, Recovery Factor of 0.9d0,...0.89d0
      Haw = HEdge + 0.9d0*(HTotal-HEdge)
      T0 = HTotal/Cp0  !approx
      Taw = Haw/Cp0  !approx

      Write(11,*) "RMach, ReU,   UEdge", RMach, ReU,   UEdge
      Write(11,*) "HTotal, T0         ", HTotal, T0
      Write(11,*) "Haw,   Taw         ", Haw,   Taw
      Write(11,*) "DEdge, TEdge, HEdge", DEdge, TEdge, HEdge
      Write(11,*) "DWall, TWall, HWall", DWall, TWall, HWall
      Write(11,*) "EntropyWall, EntropyEdge", EntropyWall, EntropyEdge
      Write(11,*) "CpWall, CpEdge", CpWall, CpEdge
      Write(11,*) "DVisWall, DVisEdge", DVisWall, DVisEdge

C     VDII transform to get Compressible Cf

C     Incompressible Cf from White
C     Incompressible CfKS from Karman-Shoenherr

      npts_KS = 30
      ReT(1) = 100.d0
      ReT(2) = 130.d0
      ReT(3) = 170.d0
      ReT(4) = 220.d0
      ReT(5) = 290.d0
      ReT(6) = 345.d0
      ReT(7) = 450.d0
      ReT(8) = 590.d0
      ReT(9) = 770.d0
      Do ipts=10,npts_KS
       ReT(ipts) = 10.*ReT(ipts-9)
      End Do

      npts_White = 30
      ReX(1) = 100000.d0
      ReX(2) = 130000.d0
      ReX(3) = 170000.d0
      ReX(4) = 220000.d0
      ReX(5) = 290000.d0
      ReX(6) = 345000.d0
      ReX(7) = 450000.d0
      ReX(8) = 590000.d0
      ReX(9) = 770000.d0
      Do ipts=10,npts_White
       ReX(ipts) = 10.*ReX(ipts-9)
      End Do

      Call CfReTKarmanS_ReXWhite(TWall,Taw,TEdge,DVisWall,DVisEdge,
     &                      CfKS,CfKSI,ReT,npts_KS,
     &                      CfWh,CfWhI,ReX,npts_White)

      Write(11,*) "ReT, CfKSI, CfKS"
      Do ipts=1,npts_KS
       Write(11,*) ReT(ipts), CfKSI(ipts), CfKS(ipts)
      End Do
      Write(11,*) "ReX, CfWhI, CfWh"
      Do ipts=1,npts_White
       Write(11,*) ReX(ipts), CfWhI(ipts), CfWh(ipts)
       Xm  = ReX(ipts)/ReU
       Tau = 69480.d0*CfWh(ipts)
       Write(12,*) Xm, Tau, CfWh(ipts)
      End Do
C     Ch from Cf ...

      End Program VDIIfp

C***********************************************************************
      Subroutine ViscAir(TAir,DVis)
C***********************************************************************
c     compute dynamic viscosity using sutherlands eq for air
c     dyn_vis in (kg/m-sec or N-sec/m^2) at TAir(degK)
c     Coeff from DPLR cfdinput/sutherland.tran
c     Air 1.458000d-6  110.3000d0
c     N2  1.399306d-6  106.6667d0
C***********************************************************************
      implicit none

      real*8 DVis, TAir
      real*8 DVisRef,TRef

      DVisRef = 1.458d-6
      TRef    = 110.3d0   !110.4d0
      If(TAir.le.0.0d0)Stop "TAir.le.0.0d0"
      DVis = DVisRef*TAir*dsqrt(TAir)/(TAir+TRef)
c     DVis = 0.1716*(TAir/273.1)*dsqrt(TAir/273.1)*383.7/(TAir+110.6)
c     Write(6,*)
c    *    "dyn_vis =",dvis," (kg/m-sec or N-sec/m^2) at",T,"(degK)"
c     Go To 10
      Return
      End Subroutine ViscAir
C***********************************************************************
      Subroutine CAEAir(TAir,Cp,HH,Entropy)
C***********************************************************************
c     Cp,H,S curve fit from CEA-1994
c     1st line
c     Species Name
c     # Tintervals: [200-1000], [1000-6000], ([6000-20000])
c     Formation Enthalpy@298.15K
c'Air' 2         -125.530
c     a1-a5 1st line, a6-a10 2nd line ... for each T interval
c 1.00995016d+04 -1.96827561d+02  5.00915511d+00 -5.76101373d-03  1.06685993d-05
c-7.94029797d-09  2.18523191d-12  0.00000000d+00 -1.76796731d+02 -3.92150098d+00
c 2.41521443d+05 -1.25787460d+03  5.14455867d+00 -2.13854179d-04  7.06522784d-08
c-1.07148349d-11  6.57780015d-16  0.00000000d+00  6.46226319d+03 -8.14740866d+00

c Cp/R= a1*T^-2   +a2/T     +a3     +a4*T   +a5*T^2   +a6*T^3 + a7*T^4
c H/RT=-a1*T^-2   +a2*lnT/T +a3     +a4*T/2 +a5*T^2/3 +a6*T^3/4 +a7*T^4/5 +a9/T
c S/R =-a1*T^-2/2 -a2/T     +a3*lnT +a4*T   +a5*T^2/2 +a6*T^3/3 +a7*T^4/4 +a10

      implicit none
      Real*8 RGas, TAir,TInv
      Real*8 Cp, HH, Entropy
      Real*8 aa1,aa2,aa3,aa4,aa5,aa6,aa7,aa8,aa9,aa10

      RGas = 287.1d0

      if(TAir.le.1000.0d0) Then
c     Coef for 1st temperature interval (200-1000K)
       aa1  =  1.00995016d+04
       aa2  = -1.96827561d+02
       aa3  =  5.00915511d+00
       aa4  = -5.76101373d-03
       aa5  =  1.06685993d-05
       aa6  = -7.94029797d-09
       aa7  =  2.18523191d-12
       aa8  =  0.00000000d+00
       aa9  = -1.76796731d+02
       aa10 = -3.92150098d+00
      Else
c     Coef for 2nd temperature interval (1000-6000K)
       aa1  =  2.41521443d+05
       aa2  = -1.25787460d+03
       aa3  =  5.14455867d+00
       aa4  = -2.13854179d-04
       aa5  =  7.06522784d-08
       aa6  = -1.07148349d-11
       aa7  =  6.57780015d-16
       aa8  =  0.00000000d+00
       aa9  =  6.46226319d+03
       aa10 = -8.14740866d+00
      End If

      Tinv = 1.0d0/TAir

      Cp=RGas*(( aa1*Tinv  +aa2)*Tinv  +aa3
     &       +TAir*(aa4+TAir*(aa5 +TAir*(aa6 +TAir*aa7))))

      HH=RGas*(aa9 + aa2*dlog(TAir) -aa1*Tinv
     &       +TAir*(aa3 +TAir*(0.5d0*aa4+TAir*(aa5/3.0d0
     &       +TAir*(0.25d0*aa6 +0.2d0*aa7*TAir)))))

      Entropy = RGas*((0.5d0*aa1*Tinv -aa2)*Tinv  +aa3*dlog(TAir) +aa10
     &       +TAir*(aa4+TAir*(0.5d0*aa5 +TAir*(aa6/3.0d0
     &       +0.25d0*TAir*aa7))))

      Return
      End Subroutine CAEAir
C***********************************************************************
      Subroutine CfReTKarmanS_ReXWhite(Tw,Taw,TEdge,DVisWall,DVisEdge,
     &                      CfKS,CfKSI,ReT,npts_KS,
     &                      CfWh,CfWhI,ReX,npts_White)
C***********************************************************************
      implicit none

      Integer npts_KS,npts_White
      Real*8 Tw,Taw,TEdge,DVisWall,DVisEdge
      Real*8 CfKS(npts_KS),   CfKSI(npts_KS),   ReT(npts_KS)
      Real*8 CfWh(npts_White),CfWhI(npts_White),ReX(npts_White)
      Real*8 RFlog, RFlogI
       
      Integer ipts
      Real*8 Alpha, Beta, Gamma
      Real*8 FTheta, FcI, Fx

c     Gamma = dsqrt((Taw/Tw + 1.0d0)**2 -4.0d0*TEdge/Tw)

c     Gamma = dsqrt((Taw + Tw)**2 -4.0d0*TEdge*Tw)/Tw
c     Beta  = (Taw - Tw)/(Gamma*Tw)
c     Alpha = (Taw + Tw + 2.0d0*TEdge)/(Gamma*Tw)

      Gamma = dsqrt( (Taw + Tw)**2 -4.0d0*TEdge*Tw )
      Beta  = (Taw -Tw)/Gamma
      Alpha = (Taw +Tw -2.0d0*TEdge)/Gamma

      FTheta = DVisEdge/DVisWall
c     Fc = (Taw/TEdge -1.0d0)/((dasin(Alpha) +dasin(Beta))**2)
      FcI= TEdge*((dasin(Alpha) +dasin(Beta))**2)/(Taw-TEdge)
c     Fx = FTheta/Fc
      Fx = FTheta*FcI

      Write(11,*) "DVisWall, DVisEdge",DVisWall,DVisEdge,FTheta
      Write(11,*) "Gamma,Beta,Alpha",Gamma,Beta,Alpha
      Write(11,*) "FcI,FTheta,Fx",FcI,FTheta,Fx
c     Karman-Shoenherr Correlation, Cf vs ReTheta
      Do ipts=1,npts_KS
       RFLog  = dlog10(ReT(ipts)*FTheta)
       RFLogI = dlog10(ReT(ipts))
       CfKSI(ipts) = 1.0d0/(6.012d0 +RFlogI*(25.11d0 +17.08d0*RFLogI))
       CfKS(ipts)  = FcI/(6.012d0 + RFlog*(25.11d0 + 17.08d0*RFLog))
      End Do

c     White Correlation, Cf vs ReX
      Do ipts=1,npts_White
       RFLog  = dlog(0.06d0*ReX(ipts)*Fx)
       RFLogI = dlog(0.06d0*ReX(ipts))
       CfWhI(ipts) = 0.455d0/(RFLogI*RFlogI)
       CfWh(ipts)  = 0.455d0*FcI/(RFLog*RFlog)
      End Do

      Return
      End Subroutine CfReTKarmanS_ReXWhite
